#ifndef LOADFROMFILECOMMAND_H_
#define LOADFROMFILECOMMAND_H_

#include "ICommand.h"
#include "../DataTypes/DataString.h"
#include "../DataTypes/DataEntity.h"
#include "../DataTypes/DataRobot.h"
#include "../DataTypes/DataBall.h"
#include "../DataTypes/DataField.h"
#include "../DataTypes/DataObject.h"
#include "SimRobot.h"
#include "SimBall.h"
#include "SimField.h"
#include "ISimEntity.h"
#include "SimulationEngineController.h"
#include "../XmlParser/xmlParser.h"
using namespace DataTypes;
namespace SimulationEngine
{

class LoadFromFileCommand : public SimulationEngine::ICommand
{
public:
	LoadFromFileCommand();
	virtual ~LoadFromFileCommand();
	list<DataParameter*> execute(list <DataParameter *>);
private:
	DataEntity *LoadEntity(XMLNode entitynode);
	DataRobot *DecodeRobot(XMLNode robotnode);
	DataField *DecodeField(XMLNode fieldnode);
	DataBall *DecodeBall(XMLNode ballnode);
};

}

#endif /*LOADFROMFILECOMMAND_H_*/
